set sql_safe_updates=0;

SET @sgAppointmentDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
	T7.printName as BATCH_NAME,
    T8.itemValue as INTAKE_YEAR,
    T10.`firstName` AS PARENT_FIRSTNAME,
    T10.`lastName` AS PARENT_LASTNAME,
    T1.`code` AS APPLICATION_CODE,
    T2.id AS ID,T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS STUDENT_FIRSTNAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    T5.academyName AS ACADEMY_NAME,
    (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T5.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        else NULL 
    end) as FOOTER_URL 
    FROM 
    `application` T1 
    INNER JOIN 
    `applicant_person` T2 ON T2.id = T1.applicantPersonId 
    LEFT OUTER JOIN 
    `salutations` T3 ON T3.`id`=T2.`salutationId`
    LEFT OUTER JOIN
    application_program T4 ON T4.applicationId = T1.id    
    LEFT OUTER JOIN
    prog_batch_seat_config T6 ON T6.id = T4.progBatchSeatConfigId
        LEFT OUTER JOIN
    batches T7 ON T7.id = T6.programBatchId
		LEFT OUTER JOIN
    intake_year T8 ON T8.id = T7.intakeYearId      
    LEFT OUTER JOIN
    applicant_person_relationships T9 ON T9.applicantPersonId = T2.id
        LEFT JOIN
    applicant_person T10 ON T10.id = T9.relatedApplicantPersonId    
        LEFT OUTER JOIN
    academy_location T5 ON T5.id = T4.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations) 
    WHERE T2.id IN (namedParams) and T4.currentStatus = 'REJECTED' AND T9.relationship = 'FATHER'",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 8
        }
    ]
}' WHERE `dataProviderId` = @sgAppointmentDT;


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICATION_REJECTION_VELOCITY');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPLICATION_REJECTION_VELOCITY');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='Applicant');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Application Rejection Buzz',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templatedtproviderId+1,NULL,'Application Rejection Buzz',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application Unsuccessful','<html>
<head>
    <title></title>
</head>
<body>
<img height="80" width="100%" src="$recipientData[&quot;HEADER_URL&quot;]"/>
<p>$recipientData[&quot;APPLICATION_CODE&quot;]</p>

<p>Dear&nbsp;$recipientData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;PARENT_LASTNAME&quot;],</p>

<p>Thank you for your interest in applying to $recipientData[&quot;Academy_Name&quot;]&nbsp;for the year commencing $recipientData[&quot;INTAKE_YEAR&quot;]. We regret to inform you that $recipientData[&quot;STUDENT_FIRSTNAME&quot;] &rsquo;s application has not been successful.</p>

<p>Please refer to the letter attached for further details in this regard. Should you have any queries please contact the Principal who will be able to assist you.</p>

<p>Kind regards,</p>

<p>$recipientData[&quot;Academy_Name&quot;]</p>
<img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" />
</body>
</html>
');

set sql_safe_updates=1;